/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.ui;

import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.createmod.catnip.lang.ClientFontHelper;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.api.registration.StoryBoardEntry;
import net.createmod.ponder.enums.PonderConfig;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.createmod.ponder.foundation.PonderChapter;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.PonderStoryBoardEntry;
import net.createmod.ponder.foundation.PonderTag;
import net.createmod.ponder.foundation.content.DebugScenes;
import net.createmod.ponder.foundation.element.TextWindowElement;
import net.createmod.ponder.foundation.ui.AbstractPonderScreen;
import net.createmod.ponder.foundation.ui.PonderButton;
import net.createmod.ponder.foundation.ui.PonderProgressBar;
import net.createmod.ponder.foundation.ui.PonderTagScreen;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3674;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class PonderUI
extends AbstractPonderScreen {
    public static int ponderTicks;
    public static float ponderPartialTicksPaused;
    public static final Color BACKGROUND_TRANSPARENT;
    public static final Color BACKGROUND_FLAT;
    public static final Color BACKGROUND_IMPORTANT;
    public static final Couple<Color> COLOR_IDLE;
    public static final Couple<Color> COLOR_HOVER;
    public static final Couple<Color> COLOR_HIGHLIGHT;
    public static final Couple<Color> MISSING_VANILLA_ENTRY;
    public static final Couple<Color> MISSING_MODDED_ENTRY;
    private static final Vector3f DIFFUSE_LIGHT_0;
    private static final Vector3f DIFFUSE_LIGHT_1;
    private final List<PonderScene> scenes;
    private final List<PonderTag> tags;
    private List<PonderButton> tagButtons = new ArrayList<PonderButton>();
    private List<LerpedFloat> tagFades = new ArrayList<LerpedFloat>();
    private final LerpedFloat fadeIn;
    class_1799 stack;
    @Nullable
    PonderChapter chapter = null;
    private boolean userViewMode;
    private boolean identifyMode;
    private class_1799 hoveredTooltipItem = class_1799.field_8037;
    @Nullable
    private class_2338 hoveredBlockPos;
    private final class_3674 clipboardHelper;
    @Nullable
    private class_2338 copiedBlockPos;
    private final LerpedFloat finishingFlash;
    private final LerpedFloat nextUp;
    private int finishingFlashWarmup = 0;
    private int nextUpWarmup = 0;
    private final LerpedFloat lazyIndex;
    private int index = 0;
    @Nullable
    private PonderTag referredToByTag;
    private PonderButton left;
    private PonderButton right;
    private PonderButton scan;
    private PonderButton chap;
    private PonderButton userMode;
    private PonderButton close;
    private PonderButton replay;
    private PonderButton slowMode;
    private int skipCooling = 0;
    private int extendedTickLength = 0;
    private int extendedTickTimer = 0;

    public static PonderUI of(class_2960 id) {
        return new PonderUI(PonderIndex.getSceneAccess().compile(id));
    }

    public static PonderUI of(class_1799 item) {
        return new PonderUI(PonderIndex.getSceneAccess().compile(CatnipServices.REGISTRIES.getKeyOrThrow(item.method_7909())));
    }

    public static PonderUI of(class_1799 item, PonderTag tag) {
        PonderUI ponderUI = new PonderUI(PonderIndex.getSceneAccess().compile(CatnipServices.REGISTRIES.getKeyOrThrow(item.method_7909())));
        ponderUI.referredToByTag = tag;
        return ponderUI;
    }

    protected PonderUI(List<PonderScene> scenes) {
        List<PonderScene> orderedScenes;
        class_2960 location = scenes.get(0).getLocation();
        this.stack = new class_1799(CatnipServices.REGISTRIES.getItemOrBlock(location));
        this.tags = new ArrayList<PonderTag>(PonderIndex.getTagAccess().getTags(location));
        Ponder.LOGGER.debug("Ponder Scenes before ordering: {}", (Object)Arrays.toString(scenes.stream().map(PonderScene::getId).toArray()));
        try {
            orderedScenes = this.orderScenes(scenes);
            Ponder.LOGGER.debug("Ponder Scenes after ordering: {}", (Object)Arrays.toString(orderedScenes.stream().map(PonderScene::getId).toArray()));
        }
        catch (Exception e) {
            Ponder.LOGGER.warn("Unable to sort PonderScenes, using unordered List", (Throwable)e);
            orderedScenes = scenes;
        }
        this.scenes = orderedScenes;
        if (this.scenes.isEmpty()) {
            List<StoryBoardEntry> list = Collections.singletonList(new PonderStoryBoardEntry(DebugScenes::empty, "ponder", "debug/scene_1", new class_2960("minecraft", "stick")));
            this.scenes.addAll(PonderIndex.getSceneAccess().compile(list));
        }
        this.lazyIndex = LerpedFloat.linear().startWithValue(this.index);
        this.fadeIn = LerpedFloat.linear().startWithValue(0.0).chase(1.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.clipboardHelper = new class_3674();
        this.finishingFlash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.nextUp = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.4f, LerpedFloat.Chaser.EXP);
    }

    private List<PonderScene> orderScenes(List<PonderScene> scenes) {
        Map<Boolean, List<PonderScene>> partitioned = scenes.stream().collect(Collectors.partitioningBy(scene -> scene.getOrderingEntries().isEmpty()));
        List<PonderScene> scenesWithOrdering = partitioned.get(false);
        List<PonderScene> scenesWithoutOrdering = partitioned.get(true);
        if (scenesWithOrdering.isEmpty()) {
            return scenes;
        }
        ArrayList<PonderScene> sceneList = new ArrayList<PonderScene>(scenes);
        Collections.reverse(sceneList);
        Map<class_2960, PonderScene> sceneLookup = scenes.stream().collect(Collectors.toMap(PonderScene::getId, scene -> scene));
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        sceneList.forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        IntStream.range(1, scenesWithoutOrdering.size()).forEach(i -> graph.putEdge((Object)((PonderScene)scenesWithoutOrdering.get(i - 1)), (Object)((PonderScene)scenesWithoutOrdering.get(i))));
        scenesWithOrdering.forEach(scene -> {
            List<StoryBoardEntry.SceneOrderingEntry> relevantOrderings = scene.getOrderingEntries().stream().filter(entry -> scenes.stream().anyMatch(sc -> sc.getId().equals((Object)entry.sceneId()))).toList();
            if (relevantOrderings.isEmpty()) {
                return;
            }
            relevantOrderings.forEach(entry -> {
                PonderScene otherScene = (PonderScene)sceneLookup.get(entry.sceneId());
                if (entry.type() == StoryBoardEntry.SceneOrderingType.BEFORE) {
                    graph.putEdge(scene, (Object)otherScene);
                } else if (entry.type() == StoryBoardEntry.SceneOrderingType.AFTER) {
                    graph.putEdge((Object)otherScene, scene);
                }
            });
        });
        return PonderUI.topologicalSort((MutableGraph<PonderScene>)graph);
    }

    private static List<PonderScene> topologicalSort(MutableGraph<PonderScene> graph) {
        ArrayList<PonderScene> result = new ArrayList<PonderScene>();
        HashSet<PonderScene> visited = new HashSet<PonderScene>();
        HashSet<PonderScene> currentlyVisiting = new HashSet<PonderScene>();
        for (PonderScene node : graph.nodes()) {
            if (visited.contains(node) || PonderUI.dfs(node, graph, visited, currentlyVisiting, result)) continue;
            throw new IllegalArgumentException("Graph has a cycle!");
        }
        Collections.reverse(result);
        return result;
    }

    private static boolean dfs(PonderScene node, MutableGraph<PonderScene> graph, Set<PonderScene> visited, Set<PonderScene> currentlyVisiting, List<PonderScene> result) {
        if (currentlyVisiting.contains(node)) {
            return false;
        }
        if (!visited.contains(node)) {
            currentlyVisiting.add(node);
            for (PonderScene neighbor : graph.successors((Object)node)) {
                if (PonderUI.dfs(neighbor, graph, visited, currentlyVisiting, result)) continue;
                return false;
            }
            currentlyVisiting.remove(node);
            visited.add(node);
            result.add(node);
        }
        return true;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.tagButtons = new ArrayList<PonderButton>();
        this.tagFades = new ArrayList<LerpedFloat>();
        this.tags.forEach(t -> {
            int i = this.tagButtons.size();
            int x = 31;
            int y = 81 + i * 30;
            PonderButton b2 = (PonderButton)((AbstractSimiWidget)new PonderButton(x, y).showing((ScreenElement)t)).withCallback((mX, mY) -> {
                this.centerScalingOn((int)mX, (int)mY);
                ScreenOpener.transitionTo(new PonderTagScreen((PonderTag)t));
            });
            this.method_37063(b2);
            this.tagButtons.add(b2);
            LerpedFloat chase = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.05f, LerpedFloat.Chaser.exp(0.1));
            this.tagFades.add(chase);
        });
        class_315 bindings = this.field_22787.field_1690;
        int spacing = 8;
        int bX = (this.field_22789 - 20) / 2 - (70 + 2 * spacing);
        int bY = this.field_22790 - 20 - 31;
        int pX = this.field_22789 / 2 - 110;
        int pY = bY + 20 + 4;
        int pW = this.field_22789 - 2 * pX;
        this.method_37063(new PonderProgressBar(this, pX, pY, pW, 1));
        this.scan = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX, bY).withShortcut(bindings.field_1869)).showing(PonderGuiTextures.ICON_PONDER_IDENTIFY)).enableFade(0, 5)).withCallback(() -> {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            } else {
                ponderPartialTicksPaused = this.field_22787.method_1488();
            }
        });
        this.method_37063(this.scan);
        this.scan.atZLevel(600.0f);
        this.slowMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.field_22789 - 20 - 31, bY).showing(PonderGuiTextures.ICON_PONDER_SLOW_MODE)).enableFade(0, 5)).withCallback(() -> this.setComfyReadingEnabled(!this.isComfyReadingEnabled()));
        this.method_37063(this.slowMode);
        if (PonderIndex.editingModeActive()) {
            this.userMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.field_22789 - 50 - 31, bY).showing(PonderGuiTextures.ICON_PONDER_USER_MODE)).enableFade(0, 5)).withCallback(() -> {
                this.userViewMode = !this.userViewMode;
            });
            this.method_37063(this.userMode);
        }
        this.left = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.field_1913)).showing(PonderGuiTextures.ICON_PONDER_LEFT)).enableFade(0, 5)).withCallback(() -> this.scroll(false));
        this.method_37063(this.left);
        this.close = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.field_1822)).showing(PonderGuiTextures.ICON_PONDER_CLOSE)).enableFade(0, 5)).withCallback(this::method_25419);
        this.method_37063(this.close);
        this.right = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.field_1849)).showing(PonderGuiTextures.ICON_PONDER_RIGHT)).enableFade(0, 5)).withCallback(() -> this.scroll(true));
        this.method_37063(this.right);
        this.replay = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.field_1881)).showing(PonderGuiTextures.ICON_PONDER_REPLAY)).enableFade(0, 5)).withCallback(this::replay);
        this.method_37063(this.replay);
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showingElement((RenderElement)GuiGameElement.of(this.stack).scale(1.5).at(-4.0f, -4.0f));
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.skipCooling > 0) {
            --this.skipCooling;
        }
        if (this.referredToByTag != null) {
            for (int i = 0; i < this.scenes.size(); ++i) {
                PonderScene ponderScene = this.scenes.get(i);
                if (!ponderScene.getTags().contains(this.referredToByTag)) continue;
                if (i == this.index) break;
                this.scenes.get(this.index).fadeOut();
                this.index = i;
                this.scenes.get(this.index).begin();
                this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
                this.identifyMode = false;
                break;
            }
            this.referredToByTag = null;
        }
        this.lazyIndex.tickChaser();
        this.fadeIn.tickChaser();
        this.finishingFlash.tickChaser();
        this.nextUp.tickChaser();
        PonderScene activeScene = this.scenes.get(this.index);
        this.extendedTickLength = 0;
        if (this.isComfyReadingEnabled()) {
            activeScene.forEachVisible(TextWindowElement.class, twe -> {
                this.extendedTickLength = 2;
            });
        }
        if (this.extendedTickTimer == 0) {
            float lazyIndexValue;
            if (!this.identifyMode) {
                ++ponderTicks;
                if (this.skipCooling == 0) {
                    activeScene.tick();
                }
            }
            if (!this.identifyMode && Math.abs((lazyIndexValue = this.lazyIndex.getValue()) - (float)this.index) > 0.001953125f) {
                this.scenes.get(lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1).tick();
            }
            this.extendedTickTimer = this.extendedTickLength;
        } else {
            --this.extendedTickTimer;
        }
        if (activeScene.getCurrentTime() == activeScene.getTotalTime() - 1) {
            this.finishingFlashWarmup = 30;
            this.nextUpWarmup = 50;
        }
        if (this.finishingFlashWarmup > 0) {
            --this.finishingFlashWarmup;
            if (this.finishingFlashWarmup == 0) {
                this.finishingFlash.setValue(1.0);
                this.finishingFlash.setValue(1.0);
            }
        }
        if (this.nextUpWarmup > 0) {
            --this.nextUpWarmup;
            if (this.nextUpWarmup == 0) {
                this.nextUp.updateChaseTarget(1.0f);
            }
        }
        this.updateIdentifiedItem(activeScene);
    }

    public PonderScene getActiveScene() {
        return this.scenes.get(this.index);
    }

    public void seekToTime(int time) {
        if (this.getActiveScene().getCurrentTime() > time) {
            this.replay();
        }
        this.getActiveScene().seekToTime(time);
        if (time != 0) {
            this.coolDownAfterSkip();
        }
    }

    public void updateIdentifiedItem(PonderScene activeScene) {
        this.hoveredTooltipItem = class_1799.field_8037;
        this.hoveredBlockPos = null;
        if (!this.identifyMode) {
            return;
        }
        class_1041 w = this.field_22787.method_22683();
        double mouseX = this.field_22787.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480();
        double mouseY = this.field_22787.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507();
        PonderScene.SceneTransform t = activeScene.getTransform();
        class_243 vec1 = t.screenToScene(mouseX, mouseY, 1000, 0.0f);
        class_243 vec2 = t.screenToScene(mouseX, mouseY, -100, 0.0f);
        Pair<class_1799, class_2338> pair = activeScene.rayTraceScene(vec1, vec2);
        this.hoveredTooltipItem = pair.getFirst();
        this.hoveredBlockPos = pair.getSecond();
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.scroll(delta > 0.0)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    protected void replay() {
        this.identifyMode = false;
        PonderScene scene = this.scenes.get(this.index);
        if (PonderUI.method_25442()) {
            PonderIndex.reload();
            this.scenes.clear();
            this.scenes.addAll(PonderIndex.getSceneAccess().compile(scene.getLocation()));
        }
        scene.begin();
    }

    protected boolean scroll(boolean forward) {
        int prevIndex = this.index;
        this.index = forward ? this.index + 1 : this.index - 1;
        this.index = class_3532.method_15340((int)this.index, (int)0, (int)(this.scenes.size() - 1));
        if (prevIndex != this.index) {
            this.scenes.get(prevIndex).fadeOut();
            this.scenes.get(this.index).begin();
            this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
            this.identifyMode = false;
            return true;
        }
        this.index = prevIndex;
        return false;
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        partialTicks = PonderUI.getPartialTicks();
        RenderSystem.enableBlend();
        this.renderVisibleScenes(graphics, mouseX, mouseY, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        this.renderWidgets(graphics, mouseX, mouseY, this.identifyMode ? ponderPartialTicksPaused : partialTicks);
    }

    @Override
    public void method_25420(class_332 graphics) {
        super.method_25420(graphics);
    }

    protected void renderVisibleScenes(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScene(graphics, mouseX, mouseY, this.index, partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        if (Math.abs(lazyIndexValue - (float)this.index) > 0.001953125f) {
            this.renderScene(graphics, mouseX, mouseY, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, partialTicks);
        }
    }

    protected void renderScene(class_332 graphics, int mouseX, int mouseY, int i, float partialTicks) {
        DefaultSuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        PonderScene scene = this.scenes.get(i);
        double value = this.lazyIndex.getValue(this.field_22787.method_1488());
        double diff = (double)i - value;
        double slide = class_3532.method_16436((double)(diff * diff), (double)200.0, (double)600.0) * diff;
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.backupProjectionMatrix();
        class_4587 poseStack = graphics.method_51448();
        RenderSystem.setupLevelDiffuseLighting((Vector3f)DIFFUSE_LIGHT_0, (Vector3f)DIFFUSE_LIGHT_1, (Matrix4f)poseStack.method_23760().method_23761());
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        matrix4f.translate(0.0f, 0.0f, 800.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43360);
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, -800.0f);
        scene.getTransform().updateScreenParams(this.field_22789, this.field_22790, slide);
        scene.getTransform().apply(poseStack, partialTicks);
        scene.getTransform().updateSceneRVE(partialTicks);
        scene.renderScene(buffer, graphics, partialTicks);
        buffer.draw();
        class_3341 bounds = scene.getBounds();
        poseStack.method_22903();
        if (!scene.shouldHidePlatformShadow()) {
            float flash;
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            poseStack.method_22903();
            poseStack.method_46416((float)scene.getBasePlateOffsetX(), 0.0f, (float)scene.getBasePlateOffsetZ());
            UIRenderHelper.flipForGuiRender(poseStack);
            float alpha = flash = this.finishingFlash.getValue(partialTicks) * 0.9f;
            flash *= flash;
            flash = flash * 2.0f - 1.0f;
            flash *= flash;
            flash = 1.0f - flash;
            for (int f = 0; f < 4; ++f) {
                poseStack.method_46416((float)scene.getBasePlateSize(), 0.0f, 0.0f);
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 0.0f, -9.765625E-4f);
                if (flash > 0.0f) {
                    poseStack.method_22903();
                    poseStack.method_22905(1.0f, 0.5f + flash * 0.75f, 1.0f);
                    graphics.method_33284(0, -1, -scene.getBasePlateSize(), 0, 0, new Color(13041609).getRGB(), new Color(-1429798967).scaleAlpha(alpha).getRGB());
                    poseStack.method_22909();
                }
                poseStack.method_46416(0.0f, 0.0f, 0.001953125f);
                graphics.method_33284(0, 0, -scene.getBasePlateSize(), 4, 0, new Color(0x66000000).getRGB(), new Color(0).getRGB());
                poseStack.method_22909();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            }
            poseStack.method_22909();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
        }
        if (PonderIndex.editingModeActive() && !this.userViewMode) {
            poseStack.method_22905(-1.0f, -1.0f, 1.0f);
            poseStack.method_22905(0.0625f, 0.0625f, 0.0625f);
            poseStack.method_46416(1.0f, -8.0f, -0.015625f);
            poseStack.method_22903();
            poseStack.method_46416(4.0f, -3.0f, 0.0f);
            poseStack.method_46416(0.0f, 0.0f, -0.001953125f);
            for (int x = 0; x <= bounds.method_35414(); ++x) {
                poseStack.method_46416(-16.0f, 0.0f, 0.0f);
                graphics.method_51433(this.field_22793, (String)(x == bounds.method_35414() ? "x" : "" + x), 0, 0, -1, false);
            }
            poseStack.method_22909();
            poseStack.method_22903();
            poseStack.method_22905(-1.0f, 1.0f, 1.0f);
            poseStack.method_46416(0.0f, -3.0f, -4.0f);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            poseStack.method_46416(-8.0f, -2.0f, 0.03125f);
            for (int z = 0; z <= bounds.method_14663(); ++z) {
                poseStack.method_46416(16.0f, 0.0f, 0.0f);
                graphics.method_51433(this.field_22793, (String)(z == bounds.method_14663() ? "z" : "" + z), 0, 0, -1, false);
            }
            poseStack.method_22909();
            poseStack.method_22903();
            poseStack.method_46416((float)(bounds.method_35414() * -8), 0.0f, (float)(bounds.method_14663() * 8));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            for (class_2350 d : Iterate.horizontalDirections) {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 0.0f, (float)(bounds.method_14663() * 16));
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                graphics.method_51433(this.field_22793, d.name().substring(0, 1), 0, 0, 0x66FFFFFF, false);
                graphics.method_51433(this.field_22793, "|", 2, 10, 0x44FFFFFF, false);
                graphics.method_51433(this.field_22793, ".", 2, 14, 0x22FFFFFF, false);
                poseStack.method_22909();
            }
            poseStack.method_22909();
            buffer.draw();
        }
        poseStack.method_22909();
        poseStack.method_22909();
        RenderSystem.restoreProjectionMatrix();
    }

    protected void renderWidgets(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        float fade = this.fadeIn.getValue(partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        float indexDiff = lazyIndexValue - (float)this.index;
        PonderScene activeScene = this.scenes.get(this.index);
        PonderScene nextScene = this.scenes.size() > this.index + 1 ? this.scenes.get(this.index + 1) : null;
        boolean noWidgetsHovered = true;
        for (class_364 child : this.method_25396()) {
            noWidgetsHovered &= !child.method_25405((double)mouseX, (double)mouseY);
        }
        int tooltipColor = ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB();
        this.renderSceneInformation(graphics, fade, indexDiff, activeScene, tooltipColor);
        class_4587 ms = graphics.method_51448();
        if (this.identifyMode) {
            if (noWidgetsHovered && mouseY < this.field_22790 - 80) {
                ms.method_22903();
                ms.method_46416((float)mouseX, (float)mouseY, 100.0f);
                if (this.hoveredTooltipItem.method_7960()) {
                    class_5250 text = Ponder.lang().translate("ui.identify_mode", ((class_5250)this.field_22787.field_1690.field_1869.method_16007()).method_27692(class_124.field_1068)).style(class_124.field_1080).component();
                    graphics.method_51434(this.field_22793, this.field_22793.method_27527().method_27495((class_5348)text, this.field_22789 / 3, class_2583.field_24360).stream().map(t -> class_2561.method_43470((String)t.getString())).toList(), 0, 0);
                } else {
                    graphics.method_51446(this.field_22793, this.hoveredTooltipItem, 0, 0);
                }
                if (this.hoveredBlockPos != null && PonderIndex.editingModeActive() && !this.userViewMode) {
                    ms.method_46416(0.0f, -15.0f, 0.0f);
                    boolean copied = this.hoveredBlockPos.equals((Object)this.copiedBlockPos);
                    class_5250 coords = class_2561.method_43470((String)(this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260())).method_27692(copied ? class_124.field_1060 : class_124.field_1065);
                    graphics.method_51438(this.field_22793, (class_2561)coords, 0, 0);
                }
                ms.method_22909();
            }
            this.scan.flash();
        } else {
            this.scan.dim();
        }
        if (PonderIndex.editingModeActive()) {
            if (this.userViewMode) {
                this.userMode.flash();
            } else {
                this.userMode.dim();
            }
        }
        if (this.isComfyReadingEnabled()) {
            this.slowMode.flash();
        } else {
            this.slowMode.dim();
        }
        this.renderSceneOverlay(graphics, partialTicks, lazyIndexValue, Math.abs(indexDiff));
        this.renderNextUp(graphics, partialTicks, nextScene);
        this.getRenderables().forEach(w -> {
            if (w instanceof PonderButton) {
                PonderButton button = (PonderButton)w;
                button.fade().startWithValue(fade);
            }
        });
        if (this.index == 0 || this.index == 1 && lazyIndexValue < (float)this.index) {
            this.left.fade().startWithValue(lazyIndexValue);
        }
        if (this.index == this.scenes.size() - 1 || this.index == this.scenes.size() - 2 && lazyIndexValue > (float)this.index) {
            this.right.fade().startWithValue((float)this.scenes.size() - lazyIndexValue - 1.0f);
        }
        if (activeScene.isFinished()) {
            this.right.flash();
        } else {
            this.right.dim();
            this.nextUp.updateChaseTarget(0.0f);
        }
        Color c1 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(64);
        Color c2 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(32);
        Color c3 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(16);
        UIRenderHelper.breadcrumbArrow(graphics, this.field_22789 / 2 - 20, this.field_22790 - 51, 0, 20, 20, 5, c1, c2);
        UIRenderHelper.breadcrumbArrow(graphics, this.field_22789 / 2 + 20, this.field_22790 - 51, 0, -20, 20, -5, c1, c2);
        UIRenderHelper.breadcrumbArrow(graphics, this.field_22789 / 2 - 90, this.field_22790 - 51, 0, 70, 20, 5, c1, c3);
        UIRenderHelper.breadcrumbArrow(graphics, this.field_22789 / 2 + 90, this.field_22790 - 51, 0, -70, 20, -5, c1, c3);
        List<PonderTag> sceneTags = activeScene.getTags();
        boolean highlightAll = sceneTags.stream().anyMatch(tag -> tag.getId() == PonderTag.Highlight.ALL);
        double s = class_310.method_1551().method_22683().method_4495();
        IntStream.range(0, this.tagButtons.size()).forEach(i -> {
            ms.method_22903();
            PonderTag tag = this.tags.get(i);
            LerpedFloat chase = this.tagFades.get(i);
            PonderButton button = this.tagButtons.get(i);
            if (button.method_25405(mouseX, mouseY)) {
                chase.updateChaseTarget(1.0f);
            } else {
                chase.updateChaseTarget(0.0f);
            }
            chase.tickChaser();
            if (highlightAll || sceneTags.contains(tag)) {
                button.flash();
            } else {
                button.dim();
            }
            int x = button.method_46426() + button.method_25368() + 4;
            int y = button.method_46427() - 2;
            ms.method_46416((float)x, (float)y + 5.0f * (1.0f - fade), 800.0f);
            float fadedWidth = 200.0f * chase.getValue(partialTicks);
            UIRenderHelper.streak(graphics, 0.0f, 0, 12, 26, (int)fadedWidth);
            RenderSystem.enableScissor((int)((int)((double)x * s)), (int)0, (int)((int)((double)fadedWidth * s)), (int)((int)((double)this.field_22790 * s)));
            String tagName = tag.getTitle();
            graphics.method_51433(this.field_22793, tagName, 3, 8, ((Color)UIRenderHelper.COLOR_TEXT_ACCENT.getFirst()).getRGB(), false);
            RenderSystem.disableScissor();
            ms.method_22909();
        });
        this.renderHoverTooltips(graphics, tooltipColor);
        RenderSystem.enableDepthTest();
    }

    private void renderHoverTooltips(class_332 graphics, int tooltipColor) {
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 500.0f);
        int tooltipY = this.field_22790 - 16;
        if (this.scan.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.identify", new Object[0]).component(), this.scan.method_46426() + 10, tooltipY, tooltipColor);
        }
        if (this.index != 0 && this.left.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.previous", new Object[0]).component(), this.left.method_46426() + 10, tooltipY, tooltipColor);
        }
        if (this.close.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.close", new Object[0]).component(), this.close.method_46426() + 10, tooltipY, tooltipColor);
        }
        if (this.index != this.scenes.size() - 1 && this.right.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.next", new Object[0]).component(), this.right.method_46426() + 10, tooltipY, tooltipColor);
        }
        if (this.replay.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.replay", new Object[0]).component(), this.replay.method_46426() + 10, tooltipY, tooltipColor);
        }
        if (this.slowMode.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.slow_text", new Object[0]).component(), this.slowMode.method_46426() + 5, tooltipY, tooltipColor);
        }
        if (PonderIndex.editingModeActive() && this.userMode.method_25367()) {
            graphics.method_25300(this.field_22793, "Editor View", this.userMode.method_46426() + 10, tooltipY, tooltipColor);
        }
        poseStack.method_22909();
    }

    private void renderNextUp(class_332 graphics, float partialTicks, @Nullable PonderScene nextScene) {
        if (!this.getActiveScene().isFinished()) {
            return;
        }
        if (nextScene == null || !nextScene.isNextUpEnabled()) {
            return;
        }
        if (!(this.nextUp.getValue() > 0.0625f)) {
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)(this.right.method_46426() + 10), (float)(this.right.method_46427() - 6) + this.nextUp.getValue(partialTicks) * 5.0f, 400.0f);
        class_5250 nextUpComponent = Ponder.lang().translate("ui.next_up", new Object[0]).component();
        int boxWidth = Math.max(this.field_22793.method_1727(nextScene.getTitle()), this.field_22793.method_27525((class_5348)nextUpComponent)) + 5;
        PonderUI.renderSpeechBox(graphics, 0, 0, boxWidth, 20, this.right.method_25367(), Pointing.DOWN, false);
        poseStack.method_46416(0.0f, -29.0f, 100.0f);
        graphics.method_27534(this.field_22793, (class_2561)nextUpComponent, 0, 0, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB());
        graphics.method_25300(this.field_22793, nextScene.getTitle(), 0, 10, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        poseStack.method_22909();
    }

    private void renderSceneOverlay(class_332 graphics, float partialTicks, float lazyIndexValue, float indexDiff) {
        float scenePT = this.skipCooling > 0 ? 0.0f : partialTicks;
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 100.0f);
        this.renderOverlay(graphics, this.index, scenePT);
        if (indexDiff > 0.001953125f) {
            this.renderOverlay(graphics, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, scenePT);
        }
        poseStack.method_22909();
    }

    private void renderSceneInformation(class_332 graphics, float fade, float indexDiff, PonderScene activeScene, int tooltipColor) {
        int otherTitleWidth;
        float indexOffset;
        float absoluteIndexDiff = Math.abs(indexDiff);
        int otherIndex = this.index;
        if (this.scenes.size() != 1 && (double)absoluteIndexDiff >= 0.01 && ((otherIndex = this.index + (int)(indexOffset = Math.signum(indexDiff))) < 0 || otherIndex >= this.scenes.size())) {
            return;
        }
        String title = activeScene.getTitle();
        String otherTitle = this.scenes.get(otherIndex).getTitle();
        int maxTitleWidth = 180;
        int titleWidth = this.field_22793.method_1727(title);
        if (titleWidth > maxTitleWidth) {
            titleWidth = maxTitleWidth;
        }
        if ((otherTitleWidth = this.field_22793.method_1727(otherTitle)) > maxTitleWidth) {
            otherTitleWidth = maxTitleWidth;
        }
        int wrappedTitleHeight = this.field_22793.method_1713(title, maxTitleWidth);
        int otherWrappedTitleHeight = this.field_22793.method_1713(otherTitle, maxTitleWidth);
        int streakHeight = 26 + (int)class_3532.method_16439((float)absoluteIndexDiff, (float)wrappedTitleHeight, (float)otherWrappedTitleHeight);
        int streakWidth = 70 + (int)class_3532.method_16439((float)absoluteIndexDiff, (float)titleWidth, (float)otherTitleWidth);
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 400.0f);
        poseStack.method_46416(55.0f, 19.0f, 0.0f);
        UIRenderHelper.streak(graphics, 0.0f, 0, streakHeight / 2, streakHeight, (int)((float)streakWidth * fade));
        UIRenderHelper.streak(graphics, 180.0f, 0, streakHeight / 2, streakHeight, (int)(30.0f * fade));
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(BACKGROUND_FLAT)).gradientBorder(COLOR_IDLE)).at(-34.0f, 2.0f, 100.0f).withBounds(30, 30).render(graphics);
        GuiGameElement.of(this.stack).scale(2.0).at(-35.0f, 1.0f).render(graphics);
        poseStack.method_46416(4.0f, 6.0f, 0.0f);
        graphics.method_51439(this.field_22793, (class_2561)Ponder.lang().translate("ui.pondering", new Object[0]).component(), 0, 0, tooltipColor, false);
        poseStack.method_46416(0.0f, 14.0f, 0.0f);
        if (this.scenes.size() == 1 || (double)absoluteIndexDiff < 0.01) {
            ClientFontHelper.drawSplitString(poseStack, this.field_22793, title, 0, 0, maxTitleWidth, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).scaleAlphaForText(fade).getRGB());
            poseStack.method_22909();
            return;
        }
        poseStack.method_46416(0.0f, 6.0f, 0.0f);
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(indexDiff * -90.0f + Math.signum(indexDiff) * 90.0f));
        poseStack.method_46416(0.0f, -6.0f, 5.0f);
        ClientFontHelper.drawSplitString(poseStack, this.field_22793, otherTitle, 0, 0, maxTitleWidth, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).scaleAlphaForText(absoluteIndexDiff).getRGB());
        poseStack.method_22909();
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(indexDiff * -90.0f));
        poseStack.method_46416(0.0f, -6.0f, 5.0f);
        ClientFontHelper.drawSplitString(poseStack, this.field_22793, title, 0, 0, maxTitleWidth, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).scaleAlphaForText(1.0f - absoluteIndexDiff).getRGB());
        poseStack.method_22909();
    }

    private void renderOverlay(class_332 graphics, int i, float partialTicks) {
        if (this.identifyMode) {
            return;
        }
        graphics.method_51448().method_22903();
        PonderScene story = this.scenes.get(i);
        story.renderOverlay(this, graphics, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        graphics.method_51448().method_22909();
    }

    public boolean method_25402(double x, double y, int button) {
        if (this.identifyMode && this.hoveredBlockPos != null && PonderIndex.editingModeActive()) {
            long handle = this.field_22787.method_22683().method_4490();
            if (this.copiedBlockPos != null && button == 1) {
                this.clipboardHelper.method_15979(handle, "util.select().fromTo(" + this.copiedBlockPos.method_10263() + ", " + this.copiedBlockPos.method_10264() + ", " + this.copiedBlockPos.method_10260() + ", " + this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260() + ")");
                this.copiedBlockPos = this.hoveredBlockPos;
                return true;
            }
            if (PonderUI.method_25442()) {
                this.clipboardHelper.method_15979(handle, "util.select().position(" + this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260() + ")");
            } else {
                this.clipboardHelper.method_15979(handle, "util.grid().at(" + this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260() + ")");
            }
            this.copiedBlockPos = this.hoveredBlockPos;
            return true;
        }
        return super.method_25402(x, y, button);
    }

    @Override
    protected String getBreadcrumbTitle() {
        if (this.chapter != null) {
            return this.chapter.getTitle();
        }
        return this.stack.method_7909().method_7848().getString();
    }

    public class_327 getFontRenderer() {
        return this.field_22793;
    }

    protected boolean isMouseOver(double mouseX, double mouseY, int x, int y, int w, int h) {
        boolean hovered = !(mouseX < (double)x) && !(mouseX > (double)(x + w));
        return hovered &= !(mouseY < (double)y) && !(mouseY > (double)(y + h));
    }

    public static void renderSpeechBox(class_332 graphics, int x, int y, int w, int h, boolean highlighted, Pointing pointing, boolean returnWithLocalTransform) {
        class_4587 poseStack = graphics.method_51448();
        if (!returnWithLocalTransform) {
            poseStack.method_22903();
        }
        int boxX = x;
        int boxY = y;
        int divotX = x;
        int divotY = y;
        int divotRotation = 0;
        int divotSize = 8;
        int distance = 1;
        int divotRadius = divotSize / 2;
        Couple<Color> borderColors = highlighted ? PonderButton.COLOR_HOVER : COLOR_IDLE;
        Color c = switch (pointing) {
            default -> {
                divotRotation = 0;
                boxX -= w / 2;
                boxY -= h + divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY -= divotSize + distance;
                yield (Color)borderColors.getSecond();
            }
            case Pointing.LEFT -> {
                divotRotation = 90;
                boxX += divotSize + 1 + distance;
                boxY -= h / 2;
                divotX += distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.RIGHT -> {
                divotRotation = 270;
                boxX -= w + divotSize + 1 + distance;
                boxY -= h / 2;
                divotX -= divotSize + distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.UP -> {
                divotRotation = 180;
                boxX -= w / 2;
                boxY += divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY += distance;
                yield (Color)borderColors.getFirst();
            }
        };
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(BACKGROUND_FLAT)).gradientBorder(borderColors)).at(boxX, boxY, 100.0f).withBounds(w, h).render(graphics);
        poseStack.method_22903();
        poseStack.method_46416((float)(divotX + divotRadius), (float)(divotY + divotRadius), 110.0f);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)divotRotation));
        poseStack.method_46416((float)(-divotRadius), (float)(-divotRadius), 0.0f);
        PonderGuiTextures.SPEECH_TOOLTIP_BACKGROUND.render(graphics, 0, 0);
        PonderGuiTextures.SPEECH_TOOLTIP_COLOR.render(graphics, 0, 0, c);
        poseStack.method_22909();
        if (returnWithLocalTransform) {
            poseStack.method_46416((float)boxX, (float)boxY, 0.0f);
            return;
        }
        poseStack.method_22909();
    }

    public class_1799 getHoveredTooltipItem() {
        return this.hoveredTooltipItem;
    }

    public class_1799 getSubject() {
        return this.stack;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI otherUI = (PonderUI)other;
            return !otherUI.stack.method_7960() && this.stack.method_31574(otherUI.stack.method_7909());
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public void shareContextWith(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI ponderUI = (PonderUI)other;
            ponderUI.referredToByTag = this.referredToByTag;
        }
    }

    public static float getPartialTicks() {
        float renderPartialTicks = class_310.method_1551().method_1488();
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof PonderUI) {
            PonderUI ui = (PonderUI)class_4372;
            if (ui.identifyMode) {
                return ponderPartialTicksPaused;
            }
            return (renderPartialTicks + (float)(ui.extendedTickLength - ui.extendedTickTimer)) / (float)(ui.extendedTickLength + 1);
        }
        return renderPartialTicks;
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public void coolDownAfterSkip() {
        this.skipCooling = 15;
    }

    public void method_25432() {
        super.method_25432();
        this.hoveredTooltipItem = class_1799.field_8037;
    }

    public boolean isComfyReadingEnabled() {
        return (Boolean)PonderConfig.Client().comfyReading.get();
    }

    public void setComfyReadingEnabled(boolean slowTextMode) {
        PonderConfig.Client().comfyReading.set(slowTextMode);
    }

    static {
        BACKGROUND_TRANSPARENT = new Color(-587202560, true);
        BACKGROUND_FLAT = new Color(-16777216, true);
        BACKGROUND_IMPORTANT = new Color(-586281440, true);
        COLOR_IDLE = Couple.create(new Color(1090514653, true), new Color(553643741, true)).map(Color::setImmutable);
        COLOR_HOVER = Couple.create(new Color(0x70FFFFFF, true), new Color(0x30FFFFFF, true)).map(Color::setImmutable);
        COLOR_HIGHLIGHT = Couple.create(new Color(-251662627, true), new Color(1627385565, true)).map(Color::setImmutable);
        MISSING_VANILLA_ENTRY = Couple.create(new Color(0x505000FF, true), new Color(1344798847, true)).map(Color::setImmutable);
        MISSING_MODDED_ENTRY = Couple.create(new Color(1889027328, true), new Color(1885938688, true)).map(Color::setImmutable);
        DIFFUSE_LIGHT_0 = new Vector3f(-0.2f, 1.0f, 0.7f).normalize();
        DIFFUSE_LIGHT_1 = new Vector3f(0.2f, 1.0f, -0.7f).normalize();
    }
}

